/*!
 * @file        bsp_usart.h
 *
 * @brief       Header for bsp_usart.c module
 *
 * @version     V1.0.2
 *
 * @date        2022-06-23
 *
 * @attention
 *
 *  Copyright (C) 2021-2022 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be usefull and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Define to prevent recursive inclusion */
#ifndef _BSP_USART_H
#define _BSP_USART_H

/* Includes */
#include "Board.h"
#include "bsp_delay.h"

/** @addtogroup Examples
  @{
  */

/** @addtogroup DCI_OV2640
  @{
  */

/** @defgroup DCI_OV2640_Macros Macros
  @{
*/

#define USART1_REV_LEN              200

/**@} end of group DCI_OV2640_Macros*/

/** @defgroup DCI_OV2640_Structures Structures
  @{
*/

/*!
 * @brief     USART receive status structure
 */
typedef struct
{
    union
    {
        uint16_t USART_RX_STA;

        struct
        {
            uint16_t VALID_LENGHT                   :14;    //!< The lenght of valid data
            uint16_t FLAG_FRAME_BREAK               :1;     //!< Data frame break flag
            uint16_t FLAG_FRAME_END                 :1;     //!< Data frame end flag
        }USART_RX_STA_B;
    };

} USART_RX_STA_T;

/**@} end of group DCI_OV2640_Structures*/

/** @defgroup DCI_OV2640_Variables Variables
  @{
  */

/* extern variables*/
extern u8 rxBufUSART1[USART1_REV_LEN];
extern USART_RX_STA_T rxStaUSART1;

/**@} end of group DCI_OV2640_Variables */

/** @defgroup DCI_OV2640_Functions Functions
  @{
  */

/* function declaration*/
void USART1_Init(uint32_t baud);
void USART_Write(USART_T* usart,uint8_t *dat, uint32_t count);
void USART_Receive_Isr(void);
#endif

/**@} end of group DCI_OV2640_Functions */
/**@} end of group DCI_OV2640 */
/**@} end of group Examples */
